/*
 * Decompiled with CFR 0.152.
 */
package entities.creatures;

import core.GameWindow;
import core.Sprite;
import core.states.GameState;
import entities.Entity;
import java.util.ArrayList;
import java.util.HashMap;
import strategies.logic.Logic;
import util.ResourceManager;

public abstract class CreatureEntity
extends Entity {
    protected GameState game;
    protected double prevDx;
    protected double prevDy;
    protected HashMap<Sprite, Long> effects;
    protected ArrayList<Sprite> effectsRemoveList;
    protected HashMap<Double, Long> moveSpeedMultipliers;
    protected ArrayList<Double> moveSpeedMultipliersRemoveList;
    protected String originalSprite;
    protected double moveSpeed = 0.0;
    protected double normalMoveSpeed = 0.0;
    protected int maxHitpoints = 0;
    protected int hitpoints;
    protected int shield;
    protected int lastMaxShield;
    protected long lastShieldTime;
    protected long lastStunTime;
    protected int lastShieldDuration;
    protected int lastStunDuration;
    protected int shotCooldown = 0;
    protected int abilityQCooldown = 0;
    protected int abilityWCooldown = 0;
    protected int abilityECooldown = 0;
    protected int abilityRCooldown = 0;
    protected long lastShotTime;
    protected long lastAbilityQTime;
    protected long lastAbilityWTime;
    protected long lastAbilityETime;
    protected long lastAbilityRTime;
    protected Sprite entityIcon;
    protected Sprite healthbar;
    protected Sprite shieldbar;
    protected Sprite barborder;
    protected Logic logic = null;

    public CreatureEntity(GameState game, String sprite, int x, int y) {
        super(sprite, x, y);
        this.game = game;
        this.effects = new HashMap();
        this.effectsRemoveList = new ArrayList();
        this.moveSpeedMultipliers = new HashMap();
        this.moveSpeedMultipliersRemoveList = new ArrayList();
        this.originalSprite = sprite;
        this.healthbar = ResourceManager.get().getSprite("interface/healthbar");
        this.shieldbar = ResourceManager.get().getSprite("interface/shieldbar");
        this.barborder = ResourceManager.get().getSprite("interface/barborder");
        this.set();
    }

    protected void set() {
        this.sprite = ResourceManager.get().getSprite(this.originalSprite);
        this.prevDy = 0.0;
        this.prevDx = 0.0;
        this.lastStunTime = 0L;
        this.lastShieldTime = 0L;
        this.lastStunDuration = 0;
        this.lastShieldDuration = 0;
        this.lastAbilityRTime = 0L;
        this.lastAbilityETime = 0L;
        this.lastAbilityWTime = 0L;
        this.lastAbilityQTime = 0L;
        this.lastShotTime = 0L;
        this.hitpoints = this.maxHitpoints;
        this.lastMaxShield = 0;
        this.shield = 0;
        this.refreshMoveSpeed();
    }

    public void reset() {
        this.set();
        this.effects.clear();
        this.effectsRemoveList.clear();
        this.moveSpeedMultipliers.clear();
        this.moveSpeedMultipliersRemoveList.clear();
    }

    public void setHitpoints(int hitpoints) {
        this.maxHitpoints = this.hitpoints = hitpoints;
    }

    public int getHitpoints() {
        return this.hitpoints;
    }

    public int getMaxHitpoints() {
        return this.maxHitpoints;
    }

    public int getShield() {
        return this.shield;
    }

    public int getLastMaxShield() {
        return this.lastMaxShield;
    }

    public void setMoveSpeed(double moveSpeed) {
        this.normalMoveSpeed = this.moveSpeed = moveSpeed;
        this.refreshMoveSpeed();
    }

    public double getMoveSpeed() {
        return this.moveSpeed;
    }

    public double getMoveSpeedMultiplier() {
        double moveSpeedMultiplier = 1.0;
        for (double multiplier : this.moveSpeedMultipliers.keySet()) {
            moveSpeedMultiplier *= multiplier;
        }
        return moveSpeedMultiplier;
    }

    protected void refreshMoveSpeed() {
        this.moveSpeed = this.normalMoveSpeed * this.getMoveSpeedMultiplier();
    }

    public void damage(Entity entity, int damage) {
        if (this.shield >= damage) {
            this.shield -= damage;
        } else {
            this.shield = 0;
            this.hitpoints -= (damage -= this.shield);
        }
        this.checkAlive();
    }

    public void stun(int duration) {
        this.lastStunTime = this.game.getTime();
        this.lastStunDuration = duration;
        this.prevDx = this.dx;
        this.prevDy = this.dy;
        this.dy = 0.0;
        this.dx = 0.0;
    }

    public boolean isStunned() {
        return this.lastStunTime != 0L && this.lastStunTime + (long)this.lastStunDuration - this.game.getTime() > 0L;
    }

    public void shield(int amount, int duration) {
        if (this.shield <= amount) {
            this.shield = this.lastMaxShield = amount;
            this.lastShieldTime = this.game.getTime();
            this.lastShieldDuration = duration;
        }
    }

    protected boolean canMove() {
        return !this.isStunned();
    }

    @Override
    public void move(long delta) {
        if (!this.canMove()) {
            return;
        }
        super.move(delta);
    }

    @Override
    public void doLogic() {
        super.doLogic();
        if (this.isStunned() && this.lastStunTime + (long)this.lastStunDuration < this.game.getTime()) {
            this.dx = this.prevDx;
            this.dy = this.prevDy;
        }
        if (this.shield > 0 && this.lastShieldTime + (long)this.lastShieldDuration < this.game.getTime()) {
            this.shield = 0;
        }
        for (Sprite sprite : this.effects.keySet()) {
            if (this.effects.get(sprite) >= this.game.getTime()) continue;
            this.effectsRemoveList.add(sprite);
        }
        for (Sprite sprite : this.effectsRemoveList) {
            if (!this.effects.containsKey(sprite)) continue;
            this.effects.remove(sprite);
        }
        this.effectsRemoveList.clear();
        for (double multiplier : this.moveSpeedMultipliers.keySet()) {
            if (this.moveSpeedMultipliers.get(multiplier) >= this.game.getTime()) continue;
            this.moveSpeedMultipliersRemoveList.add(multiplier);
        }
        for (double multiplier : this.moveSpeedMultipliersRemoveList) {
            if (!this.moveSpeedMultipliers.containsKey(multiplier)) continue;
            this.moveSpeedMultipliers.remove(multiplier);
        }
        this.moveSpeedMultipliersRemoveList.clear();
        this.refreshMoveSpeed();
        if (this.logic != null) {
            this.logic.sync();
        }
    }

    public void useShot() {
        if (this.isShotOnCooldown()) {
            return;
        }
        this.lastShotTime = this.game.getTime();
        this.shot();
    }

    public void useAbilityQ() {
        if (this.isAbilityQOnCooldown()) {
            return;
        }
        this.lastAbilityQTime = this.game.getTime();
        this.abilityQ();
    }

    public void useAbilityW() {
        if (this.isAbilityWOnCooldown()) {
            return;
        }
        this.lastAbilityWTime = this.game.getTime();
        this.abilityW();
    }

    public void useAbilityE() {
        if (this.isAbilityEOnCooldown()) {
            return;
        }
        this.lastAbilityETime = this.game.getTime();
        this.abilityE();
    }

    public void useAbilityR() {
        if (this.isAbilityROnCooldown()) {
            return;
        }
        this.lastAbilityRTime = this.game.getTime();
        this.abilityR();
    }

    protected abstract void shot();

    protected abstract void abilityQ();

    protected abstract void abilityW();

    protected abstract void abilityE();

    protected abstract void abilityR();

    public long getShotCooldown() {
        return Math.max(this.lastShotTime + (long)this.shotCooldown - this.game.getTime(), 0L);
    }

    public long getAbilityQCooldown() {
        return Math.max(this.lastAbilityQTime + (long)this.abilityQCooldown - this.game.getTime(), 0L);
    }

    public long getAbilityWCooldown() {
        return Math.max(this.lastAbilityWTime + (long)this.abilityWCooldown - this.game.getTime(), 0L);
    }

    public long getAbilityECooldown() {
        return Math.max(this.lastAbilityETime + (long)this.abilityECooldown - this.game.getTime(), 0L);
    }

    public long getAbilityRCooldown() {
        return Math.max(this.lastAbilityRTime + (long)this.abilityRCooldown - this.game.getTime(), 0L);
    }

    public boolean isShotOnCooldown() {
        return this.getShotCooldown() > 0L;
    }

    public boolean isAbilityQOnCooldown() {
        return this.getAbilityQCooldown() > 0L;
    }

    public boolean isAbilityWOnCooldown() {
        return this.getAbilityWCooldown() > 0L;
    }

    public boolean isAbilityEOnCooldown() {
        return this.getAbilityECooldown() > 0L;
    }

    public boolean isAbilityROnCooldown() {
        return this.getAbilityRCooldown() > 0L;
    }

    public void heal(int heal) {
        this.hitpoints = this.hitpoints + heal > this.maxHitpoints ? this.maxHitpoints : (this.hitpoints += heal);
    }

    protected void checkAlive() {
        if (this.shield == 0) {
            this.removeEffectByType("shield");
        }
        if (this.hitpoints <= 0) {
            this.hitpoints = 0;
            this.notifyDeath();
        }
    }

    public void notifyDeath() {
        this.game.removeEntity(this);
    }

    public void addEffect(String ref, long end) {
        this.effects.put(ResourceManager.get().getSprite("effects/" + ref), end);
    }

    public void removeEffect(String ref) {
        for (Sprite sprite : this.effects.keySet()) {
            if (!sprite.getFilename().equals(ref)) continue;
            this.effectsRemoveList.add(sprite);
        }
    }

    public long getEffectDuration(String ref) {
        for (Sprite sprite : this.effects.keySet()) {
            if (!sprite.getFilename().equals(ref)) continue;
            return this.effects.get(sprite);
        }
        return 0L;
    }

    public boolean hasEffect(String ref) {
        for (Sprite sprite : this.effects.keySet()) {
            if (!sprite.getFilename().equals(ref)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEffectType(String ref) {
        for (Sprite sprite : this.effects.keySet()) {
            if (!sprite.getFilename().startsWith(ref)) continue;
            return true;
        }
        return false;
    }

    public void removeEffectByType(String ref) {
        for (Sprite sprite : this.effects.keySet()) {
            if (!sprite.getFilename().startsWith(ref)) continue;
            this.effectsRemoveList.add(sprite);
        }
    }

    public void addMoveSpeedMultiplier(double multiplier, long end) {
        this.moveSpeedMultipliers.put(multiplier, end);
    }

    @Override
    public void draw() {
        super.draw();
        for (Sprite sprite : this.effects.keySet()) {
            sprite.draw((int)(this.x + (double)(this.getW() / 2)) - sprite.getWidth() / 2, (int)(this.y + (double)(this.getH() / 2)) - sprite.getHeight() / 2);
        }
    }

    public void drawHealthbar(int x, int y) {
        if (this.entityIcon != null) {
            this.entityIcon.draw(x, y);
            this.healthbar.draw(x + 50, y + 3, (int)((double)(this.getHitpoints() * 100 / this.getMaxHitpoints()) * 1.2), 20);
            this.barborder.draw(x + 49, y + 2, 122, 1);
            this.barborder.draw(x + 49, y + 23, 122, 1);
            this.barborder.draw(x + 49, y + 3, 1, 20);
            this.barborder.draw(x + 170, y + 3, 1, 20);
            ResourceManager.get().getGameWindow().drawText(GameWindow.FONT_SMALL, x + 110, y + 5, String.valueOf(this.getHitpoints()) + "/" + this.getMaxHitpoints(), 2);
            if (this.getShield() > 0 && this.getLastMaxShield() > 0) {
                this.shieldbar.draw(x + 50, y + 25, (int)((double)(this.getShield() * 100 / this.getLastMaxShield()) * 1.2), 20);
                this.barborder.draw(x + 49, y + 24, 122, 1);
                this.barborder.draw(x + 49, y + 45, 122, 1);
                this.barborder.draw(x + 49, y + 25, 1, 20);
                this.barborder.draw(x + 170, y + 25, 1, 20);
                ResourceManager.get().getGameWindow().drawText(GameWindow.FONT_SMALL, x + 110, y + 28, String.valueOf(this.getShield()) + "/" + this.getLastMaxShield(), 2);
            }
        }
    }

    @Override
    public void collidedWith(Entity other) {
    }
}

